; E C O N O M Y   M E T E R
;
; Pinout:
;
;	Port   Function      Name   Logic  Dir.
;	----------------------------------------
;	RA0:Display switch    PWR    Pon.   out
;	RA1:SDA               SDA    Neg.   out
;	RA2:SCL               SCL    Neg.   out
;	RA3:MRQ               MRQ    Neg.   out
;	RA4:LED (ST,OC)      NLED    Neg.   out

;	RB0:-                  -      -      -
;	RB1:SDA               SDA    Pon.   in
;	RB2:-                  -      -      -
;	RB3:Speed Sensor      VSS    Pon.   in
;	RB4:Injector valve    INJ    Neg.   in
;	RB5:-                  -      -      -
;	RB6:-                  -      -      -
;	RB7:-                  -      -      -
;
;	Speed:		max 500Hz - min 10Hz (   2ms - 100ms), ( 180 -    4kmh)    [kmh]*2,5=[Hz]
;	Valve:		max  60Hz - min  4Hz (16,6ms - 250ms), (7200 - 480rpm) [RPM]/120=[Hz]
;	Timer (spd):	4us (1:4) (4u - 125ms) Without TMR0H  MSB
;	Timer (rpm):	8us (1:8) (8u - 250ms) Without TMR0H  MSB
;	Clock:		4MHz
;

	list p=16f84
	Title "fogy.asm"

	include <fogy.inc>


AREG	EQU	0ch		; global tag
BREG	EQU	0dh		; global tag
CREG	EQU	0eh		; global tag
TMR0H	EQU	0fh		; Timer 0 high byte
DREG	EQU	10h		; global tag
I2CBYTE	EQU	11h		; I2C send byte
SEBH	EQU	12h		; Speed high byte
SEBL	EQU	13h		; Speed low byte
SEBK	EQU	14h		; Speed exponent
SZLP1H	EQU	15h		; Valve ontime high
SZLP1L	EQU	16h		; Valve ontime low
SZLP1K	EQU	17h		; Valve ontime exp.
SZLPTH	EQU	18h		; Valve full period time high
SZLPTL	EQU	19h		; Valve full period time low
SZLPTK	EQU	1ah		; Valve full period time exp.
KITH	EQU	1bh		; Valve factor high
KITL	EQU	1ch		; Valve factor low
KITK	EQU	1dh		; Valve factor exp.
OSZT1	EQU	1eh		; Divider
OSZT1K	EQU	1fh		; Divider exp.
OSZT2	EQU	20h		; Dividend
OSZT2K	EQU	21h		; Dividend exp.
OSZTEL	EQU	22h		; Divisions result low
OSZTEH	EQU	23h		; Divisions result high
OSZTEK	EQU	24h		; Divisions result exp.
SZOR1	EQU	25h		; Multiplier
SZOR1K	EQU	26h		; Multiplier exp.
SZOR2	EQU	27h		; Multiplicand
SZOR2K	EQU	28h		; Multiplicand exp.
SZOREL	EQU	29h		; Multiplication`s result low
SZOREH	EQU	2ah		; Multiplication`s result high
SZOREHH	EQU	2bh		; Multiplication`s result highest
SZOREK	EQU	2ch		; Multiplication`s result exp.
FOGYL	EQU	2dh		; Consuption low
FOGYH	EQU	2eh		; Consuption high
FOGYK	EQU	2fh		; Consuption exp.
KIJ1	EQU	30h		; displeyed number (10^1)
KIJ0	EQU	31h		; displeyed number (10^0)
KIJT	EQU	32h		; displeyed number (10^-1)
VSZ	EQU	33h		; The number of endless consuption. (after 31 turn off the display)
FOGYHE	EQU	34h		; The previous cons. integer
FOGYLE	EQU	35h		; The previous cons. fraction

; The first 1 in a floating point number is outsteped
; The exponent mean: How much 0 missing from the numbers end
;
; eg: number=68h, exp.=FBh => (1) 0110 1000, * 2^-5 = 1 011,0 1000 = 11,25d
;
; Attention!! n=00h, e=00h => (1) 0000 0000, * 2^0  = 1 0000 0000, = 512d
;
; ========================== Vektorok ============================

	org	00h
	goto	start		; mainprog

	org	3ffh
	goto	start		; mainprog

; ========================== Timer IT ============================
; 1,024msect@4MHz
;    or
; 2,038msec@4MHz

	org	4h

	incf	TMR0H
	bcf	INTCON,T0IF
	retfie

; ****************************************************************
; ************************** Mainprog ****************************
; ****************************************************************

	org	08h
start
; =================== A periferiak inicializalasa ================

	bcf	STATUS,RP0		;Select Bank 0
	clrf	PORTA
	BSF	STATUS,RP0 		;Select Bank 1
	clrf 	TRISA 			;Set RA as outputs
	bsf	OPTION_REG,NOT_RBPU	;PORTB pull-ups disabled
	movlw	0x18
	movwf	TRISB			;Set RB as inputs

; ===================== TIMER0 setup ============================

	bsf	OPTION_REG,PS0
	bcf	OPTION_REG,PS1		;Prescaler=1:4
	bcf	OPTION_REG,PS2

	bcf	OPTION_REG,PSA		;Prescaler to TMR0
	bcf	OPTION_REG,T0CS		;TIMER0 from int. clk

	bcf	STATUS,RP0		;Select BANK0

	bcf	INTCON,T0IF		;TIMER0 IT flag clear
	bsf	INTCON,T0IE		;TIMER0 IT enable

	bsf	INTCON,GIE		;GLOBAL IT enable

; ========================= Mainprog =============================

foprg

	movlw	0x20		; Default: The display is off
	movwf	VSZ		;
	movlw	0x63		; 99
	movwf	FOGYHE		;	previous cons.
	movlw	0xff		; ,9
	movwf	FOGYLE

	clrf	PORTB		; PROBA!!!

; ==================== Show Wagon ===============================
; (I dont know when show the first time the "Wagon R+" after the switch on,
; because I send many time: 10*(130+50)ms)

	bsf	PORTA,PWR	; Display turn on
	call	wait01s

	movlw	0x0a
	movwf	DREG

wkiir	call	wagon		; Cycle 10 times
	call	wait01s

	decfsz	DREG
	goto	wkiir

; ==================== Speed measuration ==========================

seb	clrf	PORTB
	bsf	PORTB,0		; PROBA!!!

	bsf	STATUS,RP0 	;Select Bank 1
	bsf	OPTION_REG,PS0
	bcf	OPTION_REG,PS1	;Prescaler=1:4
	bcf	OPTION_REG,PS2
	bcf	STATUS,RP0	;Select BANK0

	clrf	TMR0		;
	clrf	TMR0H		;

	bcf	INTCON,T0IF	; clear TIMER0 IT flag
	bsf	INTCON,T0IE	; TIMER0 IT enable

seb0	btfsc	TMR0H,7		; I measure from rising to rising,
	goto	vgtln		; because I wait to 0
	btfsc	PORTB,VSS	;
	goto	seb0		;

seb1	btfsc	TMR0H,7
	goto	vgtln
	btfss	PORTB,VSS
	goto	seb1		; the first rising

	clrf	TMR0
	clrf	TMR0H		; Start the measuring

seb2	btfsc	TMR0H,7
	goto	vgtln
	btfsc	PORTB,VSS
	goto	seb2		; falling

seb3	btfsc	TMR0H,7
	goto	vgtln
	btfss	PORTB,VSS
	goto	seb3		; Second rising

seb4	movf	TMR0,1	; *	Clear the prescaler (so dont inc. the TMR0)
	bcf	INTCON,T0IE	; TIMER0 IT disable

	movf	TMR0,1	; *
	movf	TMR0,0
	movwf	SEBL		; Moving
	movf	TMR0H,0
	movwf	SEBH

; ============= from fix point speed make a floating point ================

	bsf	PORTB,7		; PROBA!!!

; But first: Is it 0 (something noise)

	movf	SEBL,1
	btfss	STATUS,Z
	goto	sebleb0

	movf	SEBH,1
	btfsc	STATUS,Z
	goto	seb

sebleb0
	clrf	SEBK
sebleb	decf	SEBK,1

	movf	SEBK,0
	sublw	0xee
	btfsc	STATUS,C	; If exp.<-18 then something error
	goto	seb		; and new measuring

	bcf	STATUS,C
	rlf	SEBL,1		; rotate, until the first 1 go out
	rlf	SEBH,1		;
	btfss	STATUS,C
	goto	sebleb

; =================== The ventils time measuring ========================

szlp
	clrf	PORTB
	bsf	PORTB,1		; PROBA!!!

	bsf	STATUS,RP0 	;Select Bank 1
	bcf	OPTION_REG,PS0
	bsf	OPTION_REG,PS1	;Prescaler=1:8
	bcf	OPTION_REG,PS2
	bcf	STATUS,RP0	;Select BANK0

	clrf	TMR0
	clrf	TMR0H

	bcf	INTCON,T0IF	; Clear TIMER0 IT flag
	bsf	INTCON,T0IE	; TIMER0 IT enable

szlp0	btfsc	TMR0H,7		; I measure from rising to rising,
	goto	nulla		; because wait to 1
	btfss	PORTB,INJ	;
	goto	szlp0		;

szlp1	btfsc	TMR0H,7
	goto	nulla
	btfsc	PORTB,INJ	; First falling
	goto	szlp1

	clrf	TMR0
	clrf	TMR0H		; Start the measuring

szlp2	btfsc	TMR0H,7
	goto	nulla
	btfss	PORTB,INJ	; rising
	goto	szlp2

; Now closing the ventil: This is the opening time

szlp3	movf	TMR0,1	; *	Stop the prescaler
	movf	TMR0,0
	movf	TMR0,1	; *
	movwf	SZLP1L		; Save
	movf	TMR0,1	; *
	movf	TMR0H,0
	movwf	SZLP1H

szlp4	btfsc	TMR0H,7
	goto	nulla
	btfsc	PORTB,INJ	; Second falling
	goto	szlp4

szlp5	nop
	nop			; Timing because of the stoping the timer
	nop
	nop
	movf	TMR0,1	; *
	bcf	INTCON,T0IE	;TIMER0 IT disable

	movf	TMR0,1	; *
	movf	TMR0,0
	movwf	SZLPTL		; Saving
	movf	TMR0H,0
	movwf	SZLPTH

; ============= from fix point ventiltime make a floating point ===============

	bsf	PORTB,7		; PROBA!!!

; 0?

	movf	SZLP1L,1
	btfss	STATUS,Z
	goto	nullae1

	movf	SZLP1H,1
	btfsc	STATUS,Z
	goto	szlp

nullae1	movf	SZLPTL,1
	btfss	STATUS,Z
	goto	szlplb

	movf	SZLPTH,1
	btfsc	STATUS,Z
	goto	szlp

szlplb
	clrf	SZLP1K
szlp0lb	decf	SZLP1K,1

	movf	SZLP1K,0
	sublw	0xee
	btfsc	STATUS,C	;
	goto	szlp		; exp.<-18

	bcf	STATUS,C
	rlf	SZLP1L,1	; rotate
	rlf	SZLP1H,1	;

	btfss	STATUS,C
	goto	szlp0lb

	clrf	SZLPTK
szlptlb	decf	SZLPTK,1

	movf	SZLPTK,0
	sublw	0xee
	btfsc	STATUS,C	;
	goto	szlp		; exp.<-18

	bcf	STATUS,C
	rlf	SZLPTL,1	; rotate
	rlf	SZLPTH,1	;

	btfss	STATUS,C
	goto	szlptlb

; ======================= Volume factor =========================(Opened_time/Full_time)

kit	clrf	PORTB
	bsf	PORTB,2		; PROBA!!!

	movf	SZLP1H,0
	movwf	OSZT2
	movf	SZLP1K,0
	movwf	OSZT2K

	movf	SZLPTH,0
	movwf	OSZT1
	movf	SZLPTK,0
	movwf	OSZT1K

	call	osztas

	movf	OSZTEH,0
	movwf	KITH
	movf	OSZTEL,0
	movwf	KITL
	movf	OSZTEK,0
	movwf	KITK

; ======================= Consuption Calculate ==================(Ventil_factor/Speed)

fogy	clrf	PORTB
	bsf	PORTB,5		; PROBA!!!

	movf	KITH,0
	movwf	SZOR1
	movf	KITK,0
	movwf	SZOR1K

	movf	SEBH,0
	movwf	SZOR2
	movf	SEBK,0
	movwf	SZOR2K

	call	szorzas

	movf	SZOREH,0
	movwf	FOGYH
	movf	SZOREL,0
	movwf	FOGYL
	movf	SZOREK,0
	movwf	FOGYK

; ======================= Scaling =========================
;
skala	clrf	PORTB
	bsf	PORTB,6		; PROBA!!!

	movf	FOGYH,0
	movwf	SZOR1
	movf	FOGYK,0
	movwf	SZOR1K

	movlw	0x35
	movwf	SZOR2		;(1) 0011 0101 * 2^-5
	movlw	0xfb
	movwf	SZOR2K

	call	szorzas

	movf	SZOREH,0
	movwf	FOGYH
	movf	SZOREL,0
	movwf	FOGYL
	movf	SZOREK,0
	movwf	FOGYK

; =================== Consuption floating p.=> fix p.=================
; FOGYH integer
; FOGYL fraction

	movf	FOGYK,0
	sublw	0x80		; Exp + or -
	btfsc	STATUS,C
	goto	vgtln		; If positiv then endless (max: 99.9)

	movf	FOGYK,0
	sublw	0xf2		; Exp <-13
	btfsc	STATUS,C
	goto	nulla		; If less then 0 (min: 0.0)

	bsf	STATUS,C
	goto	fix0
fix1	bcf	STATUS,C
fix0	rrf	FOGYH,1
	rrf	FOGYL,1
	incfsz	FOGYK,1
	goto	fix1

	movf	FOGYH,0
	sublw	0x63
	btfss	STATUS,C	; greater then 99?
	goto	vgtln

; averaging
	movf	FOGYL,0		; Add the previous and the current
	addwf	FOGYLE,1	;
	btfsc	STATUS,C	; (By the integer carry isnt important because
	incf	FOGYHE,1	; max value is 99.
	movf	FOGYH,0		; (99d+99d=c6h)
	addwf	FOGYHE,1	; (The result placed in previous)

	bcf	STATUS,C
	rrf	FOGYHE,1	; divided by 2
	rrf	FOGYLE,1

	movf	FOGYHE,0
	movwf	FOGYH		; The result
	movf	FOGYLE,0
	movwf	FOGYL

	clrf	VSZ		; This value isnt endless, Display on
	call	konv		; hexa-dec konv

	goto	kiir

; ====================== endless cons. =======================

vgtln
	movlw	0xfd		; in the display routin add 30,
	movwf	KIJT		; so 2Dh="-".
	movwf	KIJ1
	movwf	KIJ0

	movlw	0x63
	movwf	FOGYHE		; The previuos value is too endless
	movlw	0xf0
	movwf	FOGYLE

	btfss	VSZ,5		; if VSZ<32 then inc.
	incf	VSZ,1		;

	goto	kiir

; ======================== 0 cons. ===========================

nulla
	clrf	KIJT
	clrf	KIJ0
	clrf	KIJ1

	clrf	FOGYHE		; The previous is too 0
	clrf	FOGYLE		;

	clrf	VSZ

	goto	kiir

; =========================== Display ==========================

kiir
; Display On/Off

	btfss	VSZ,5		; If VSZ=32, turn off, and go back
	goto	kiir3
	bcf	PORTA,PWR
	goto	seb

kiir3
	btfsc	PORTA,PWR	; If VSZ<32 and the display is on, then
	goto	kiir2		; go displaying

	bsf	PORTA,PWR	; If is off then turn on

	bsf	STATUS,RP0 	; Select Bank 1
	bsf	OPTION_REG,PS0
	bcf	OPTION_REG,PS1	; Prescaler=1:4 (because of timings)
	bcf	OPTION_REG,PS2
	bcf	STATUS,RP0	; Select BANK0

	call	wait1ms		; 1ms waiting (This is not enough<>0.4, 0.5 sec the power up time)

kiir2
	bcf	PORTA,NLED

	bsf	STATUS,RP0 	; Select Bank 1
	bsf	OPTION_REG,PS0
	bcf	OPTION_REG,PS1	; Prescaler=1:4 (because of timings)
	bcf	OPTION_REG,PS2
	bcf	STATUS,RP0	; Select BANK0

	bcf	PORTA,MRQ
	bcf	PORTA,SDA	; This is so sure:
	bcf	PORTA,SCL	; All high

; Start of the communication

	bsf	PORTA,MRQ	; begining:
	call	wait1ms		; MRQ neg. impulzus
	bcf	PORTA,MRQ	;

	call	wait1ms

; Start jel

	bsf	PORTA,SDA	; START:
	call	wait1ms		; SCL=1, SDA=falling
	bsf	PORTA,SCL	;

; Byte-ok kuldese

	movlw	0x4a		; displays addres
	call	sendI2C

	bsf PORTA,MRQ		; After addres go MRQ down 0

	movlw	0x40		; The decimal point turn on
	call	sendI2C		;
	movlw	0x00		; (Only this can I turn on)
	call	sendI2C

	movlw	0x4c
	call	sendI2C 	; "L"

	movlw	0x2f
	call	sendI2C		; "/"

	movlw	0x4b
	call	sendI2C 	; "K"

	movlw	0x4d
	call	sendI2C		; "M"

	movlw	0x20
	call	sendI2C		; "Space"

	movf	KIJ1,0
	btfss	STATUS,Z	; If the first char 0, then instaed of it I send "Space" (20h)
	goto	kiir0
	movlw	0x20		; "Space"
	goto	kiir1
kiir0	addlw	0x30		; ASCII=number+30h
	bcf	STATUS,C
kiir1	call	sendI2C

	movf	KIJ0,0
	addlw	0x30
	call	sendI2C 	; 2nd number

	movf	KIJT,0
	addlw	0x30
	call	sendI2C 	; 3rd (fraction)

	call	wait1ms
	bcf	PORTA,MRQ	; MRQ=1

	bsf	PORTA,SDA
	call	wait1ms
	bcf	PORTA,SCL	; Stop:
	call	wait1ms
	bcf	PORTA,SDA	; SCL=1, SDA=raising
	call	wait1ms

	bcf	PORTA,MRQ
	bcf	PORTA,SDA	; End: All high
	bcf	PORTA,SCL

	bsf	PORTA,NLED

; ========================== The end ==============================

	goto	seb

; ****************************************************************
; ************************** Routins *****************************
; ****************************************************************

; ====================== Hex-Dec konv ============================
; The fraction part of the cons place in the FOGYL
; The integer part of the cons place in the FOGYH


konv	clrf	KIJ0
	clrf	KIJ1
	clrf	KIJT

	movf	FOGYH,0
	andlw	0x0f
	sublw	0x09		; The low 4 bit>9?
	btfss	STATUS,C	;
	goto	nagy9
kis9	movf	FOGYH,0
	andlw	0x0f
	movwf	KIJ0
	goto	konv0		; If less, then end
nagy9	movlw	0x01
	movwf	KIJ1		; If greater then KIJ1=1,
	movf	FOGYH,0		; KIJ0=[Hex]-6
	addlw	0x06
	andlw	0x0f
	movwf	KIJ0

konv0	swapf	FOGYH,0		; check the high 4 bit
	andlw	0x0f
	movwf	CREG
	btfsc	STATUS,Z	; If 0
	goto	tort

dek1	incf	KIJ1,1		; in all cycle ink.
	movf	KIJ0,0
	addlw	0x16		; FOGYE*(+16)
	andlw	0x0f
	movwf	KIJ0
	sublw	0x09
	btfss	STATUS,C	; >9?
	goto	nagy9_
kis9_	movf	KIJ0,0
	andlw	0x0f
	movwf	KIJ0
	goto	dek2
nagy9_	incf	KIJ1,1
	movf	KIJ0,0
	addlw	0x06
	andlw	0x0f
	movwf	KIJ0
dek2	decfsz	CREG,1
	goto	dek1

tort	movlw	0x0a		; check fraction
	movwf	CREG		; I multiply with 10d (Ah)
	swapf	FOGYL,0		;
	andlw	0x0f
	clrf	KIJT

tort0	addwf	KIJT,1		; 10*fraction

	decfsz	CREG,1
	goto	tort0

	swapf	KIJT,0
	andlw	0x0f
	movwf	KIJT

	clrf	VSZ		; It isnt endless

	return

; ========================= Divide ===============================
;
; The divider add with itself until the sum of carry (the next place) equal the division
;

osztas
	clrf	OSZTEL
	clrf	OSZTEH
	decf	OSZTEL,1	; The start value
	decf	OSZTEH,1	;

	clrf	BREG		; BREG: the sum high byte
	clrf	CREG		; CREG: the sum highest byte
	clrf	AREG		; AREG: the sum low byte

oszt0	incf	OSZTEL,1	; In all cycle inc. the value
	movf	OSZTEL,1	;
	btfsc	STATUS,Z	; If carry the low byte then inc the next
	incf	OSZTEH,1

	movf	OSZT1,0

	addwf	AREG,1		; The result placed back the AREG
	btfss	STATUS,C	; SKIP if AREG carry
	goto	oszt2

	incf	BREG,1		; inc BREG
	btfsc	STATUS,Z	; If BREG carry then inc CREG
	incf	CREG,1

oszt2	incf	BREG,1		; inc BREG because of the out step 1
	btfsc	STATUS,Z	; If BREG carry then inc CREG
	incf	CREG,1

	btfsc	CREG,1		; End, if CREG=2
	goto	oszt1		; (Only the divider=1FFh)

	movf	BREG,0		; End, if BREG>divider,
	subwf	OSZT2,0		; and CREG=1
	btfsc	STATUS,C
	goto	oszt0		; If less, then go back
	movf	CREG,1		; CREG move itself
	btfsc	STATUS,Z	; If it isnt 0 then end
	goto	oszt0

oszt1	movf	OSZT1K,0	; calculated the exp.
	subwf	OSZT2K,0	; OSZTEK=OSZT2K-OSZT1K+8-8
;	addlw	0x08		; -8 the multiply with 256 in the begin of the routin
	movwf	OSZTEK		; +8 the placed in 2 byte

; The result konv. floating point
; (but first: <>0?)

	bsf	PORTB,7		; PROBA!!!

	movf	OSZTEL,1
	btfss	STATUS,Z
	goto	oszt3

	movf	OSZTEH,1
	btfsc	STATUS,Z
	goto	oszt4		; If result=0

oszt3	decf	OSZTEK,1
	bcf	STATUS,C
	rlf	OSZTEL,1	; rotate
	rlf	OSZTEH,1	;

	btfss	STATUS,C
	goto	oszt3

	return

oszt4	movlw	0xb0
	movwf	OSZTEK		; Result=0
	clrf	OSZTEH		; (The exp=very very little number: -80)
	clrf	OSZTEL

	return

; ======================== Multiply ===============================

szorzas

	clrf	SZOREL		; the low byte
	clrf	SZOREH		; the high byte
	clrf	SZOREHH		; the highest byte
	movlw	2		; BREG=the multiplers first 1 (Outsteped)
	movwf	BREG		; BREG=2
	movf	SZOR2,0
	movwf	CREG		; CREG is the multipler
	btfsc	STATUS,Z
	goto	szor6		; If CREG=0 then bug (A dekrement miatt tfordulna ff-re s mg 256-szor megcsinln.)

szor0	movf	SZOR1,0		; add SZOR1 SZOR2 times to SZOREL
	addwf	SZOREL,1	;
	btfss	STATUS,C
	goto	szor4

	incf	SZOREH,1	; If carry the low byte
	btfsc	STATUS,Z	;
	incf	SZOREHH,1

szor4	incf	SZOREH,1	; The outsteped 1
	btfsc	STATUS,Z	; Ha mr nem nulla akkor vge
	incf	SZOREHH,1

	decfsz	CREG,1		; If CREG<>0, then onetimes
	goto	szor0
szor6	decfsz	BREG,1		; bcause uf the outstepped 1, 256 more
	goto	szor0		; (256 lesz mert a CREG most fordult at)

szor1	movf	SZOR1K,0	; calculat the exp.
	addwf	SZOR2K,0	; KITK=SZLP1K+SZLPTK+8
	addlw	0x08		;
	movwf	SZOREK		; +8 because of part"*" of the program

; The result konv. to floating point.
; (first <>0?)

	movf	SZOREL,1
	btfss	STATUS,Z
	goto	szor3

	movf	SZOREH,1
	btfss	STATUS,Z
	goto	szor3

	movf	SZOREHH,1
	btfsc	STATUS,Z
	goto	szor5		; If 0

szor3	decf	SZOREK,1
	bcf	STATUS,C
	rlf	SZOREL,1	; rotate
	rlf	SZOREH,1	;
	rlf	SZOREHH,1

	btfss	STATUS,C
	goto	szor3

	movf	SZOREH,0
	movwf	SZOREL		; SZOREHH dont use:
	movf	SZOREHH,0	; SZOREHH>SZOREH>SZOREL
	movwf	SZOREH		; "*"

	movf	SZOREK,0
	addlw	0x08		; The exp. add 8
	movwf	SZOREK

	return

szor5	clrf	SZOREL
	clrf	SZOREH
	movlw	0xb0		; If the result=0
	movwf	SZOREK		; (-80)

	return

; ===================== wait 1msec ========================
; 1ms~=TMR0 7.bitje mikor egybe vlt (128*8*1us+6us)

wait1ms
	clrf	TMR0
	clrf	TMR0H
wait1	btfss	TMR0,7
	goto	wait1

	return

; =================== wait 0,25msec ========================
; 0,25ms~=TMR0 5.bitje mikor egybe vlt (32*8*1us+6us)

wait025ms
	clrf	TMR0
	clrf	TMR0H
wait025	btfss	TMR0,5
	goto	wait025

	return

; ==================== wait 0,1sec ========================
; the MSB TMR0H

wait01s
	clrf	TMR0
	clrf	TMR0H
wait01	btfss	TMR0H,7
	goto	wait01

	return

; ================== 1byte elkuldese I2C-n =======================
; Send the W

; Calculate the parity

sendI2C
	movwf	BREG		; Send byte (W)
	movwf	I2CBYTE		; Send byte (W)
	clrf	CREG		; The number of 1
	movlw	0x07
	movwf	AREG		; cycle value

send0	rrf	BREG		; rotate the byte,
	btfsc	STATUS,C	; and count the number of 1
	incf	CREG		; (but only the low 7 bit)
	decfsz	AREG,1
	goto	send0

	rlf	I2CBYTE,1	; Rotate, and behind the parity
	bcf	I2CBYTE,0
	btfss	CREG,0		; if CREG odd, then clear parity
	bsf	I2CBYTE,0	;

; A byte elkuldese

	movlw	8		;
	movwf	CREG		; Cycle 8x

send1
	bsf	PORTA,SCL	; Clock=0
	call	wait025ms

	btfsc	I2CBYTE,7	; byte <7> bit 0 or 1
	goto	send3
	bsf	PORTA,SDA	; 0
	goto	send4
send3
	bcf	PORTA,SDA	; 1
send4
	call	wait025ms
	bcf	PORTA,SCL	; Clock=1, valid data
	call	wait025ms

	rlf	I2CBYTE,1	; rotate

	decfsz	CREG,1		; Cycle
	goto	send1

	bsf	PORTA,SCL
	call	wait025ms

; Nyugta a slave-tol

	bcf	PORTA,SDA	; Output=1
	call	wait025ms
	bcf	PORTA,SCL	; Clock=1=> ACK
	call	wait025ms

	bcf	STATUS,C
	btfss	PORTB,SDA	; ACK OK?
	bsf	STATUS,C	; If OK, set carry (NACK)

	bsf	PORTA,SCL	; Clock=0
	call	wait025ms
	bsf	PORTA,SDA	; data=0

	return

; ==================== show Wagon R+ ========================

wagon
	bcf	PORTA,NLED

	bcf	PORTA,MRQ
	bcf	PORTA,SDA	; All high
	bcf	PORTA,SCL	;

; Kommunikacio kezdete

	bsf	PORTA,MRQ	;
	call	wait1ms		; MRQ neg. imp.
	bcf	PORTA,MRQ	;

	call	wait1ms

; Start jel

	bsf	PORTA,SDA	; START:
	call	wait1ms		; SCL=1, SDA=falling
	bsf	PORTA,SCL	;

; Byte-ok kuldese

	movlw	0x4a		; Addres
	call	sendI2C

	bsf PORTA,MRQ		; After the addres MRQ=0

	clrw
	call	sendI2C		; All lamp off
	clrw
	call	sendI2C

	movlw	0x57
	call	sendI2C		; "W"

	movlw	0x41
	call	sendI2C 	; "A"

	movlw	0x47
	call	sendI2C		; "G"

	movlw	0x4f
	call	sendI2C		; "O"

	movlw	0x4e
	call	sendI2C		; "N"

	movlw	0x20
	call	sendI2C 	; "Space"

	movlw	0x52
	call	sendI2C 	; "R"

	movlw	0x2b
	call	sendI2C		; "+"

	call	wait1ms
	bcf	PORTA,MRQ	; MRQ=1

	bsf	PORTA,SDA
	call	wait1ms
	bcf	PORTA,SCL	; Stop:
	call	wait1ms
	bcf	PORTA,SDA	; SCL=1, SDA=raising
	call	wait1ms

	bcf	PORTA,MRQ
	bcf	PORTA,SDA	; End: all high
	bcf	PORTA,SCL

	bsf	PORTA,NLED

	return

end

